﻿using Microsoft.EntityFrameworkCore;
using StokYonetimSistemi.Entities;

namespace StokYonetimSistemi.DataAccess
{
    public class StokYonetimDbContext : DbContext
    {
        public DbSet<Urun> Urunler { get; set; }
        public DbSet<Kategori> Kategoriler { get; set; }
        public DbSet<Kullanici> Kullanicilar { get; set; }
        public DbSet<StokHareketi> StokHareketleri { get; set; }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            // Kendi SQL Server bağlantı cümlenizi buraya yazın.
            // Bu, Windows Authentication kullanan local bir SQL Server Express bağlantısıdır.
            optionsBuilder.UseSqlServer("Server=.\\MURATERDOGAN;Database=StokYonetimDB;Trusted_Connection=True;TrustServerCertificate=True;");
        }
    }
}